package ru.yandex.travel.train.model.refund;

import lombok.Data;
import org.javamoney.moneta.Money;

import ru.yandex.travel.train.model.PassengerCategory;
import ru.yandex.travel.train.partners.im.model.ImBlankStatus;
import ru.yandex.travel.train.partners.im.model.orderinfo.ImOperationStatus;

@Data
public class PassengerRefundInfo {
    private int customerId;
    private int blankId;
    private Integer buyOperationId;
    private PassengerCategory passengerCategory;
    private String refundReferenceId;
    private Integer refundBlankId;
    private Integer refundOperationId;
    private ImBlankStatus blankStatus;
    private ImOperationStatus refundOperationStatus;
    private Money calculatedRefundTicketAmount;
    private Money actualRefundTicketAmount;
    private Money calculatedRefundFeeAmount;
    private Money calculatedRefundInsuranceAmount;
    private String checkDocumentNumber;

    private boolean dependent; // true for baby without place and with parents blankId

    public Money calculateActualRefundSum() {
        if (actualRefundTicketAmount != null) {
            return actualRefundTicketAmount.add(calculatedRefundFeeAmount).add(calculatedRefundInsuranceAmount);
        } else {
            return calculatedRefundTicketAmount.add(calculatedRefundFeeAmount).add(calculatedRefundInsuranceAmount);
        }
    }
}
