package ru.yandex.travel.train.model.refund;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.javamoney.moneta.Money;

import ru.yandex.travel.commons.proto.ProtoCurrencyUnit;
import ru.yandex.travel.train.partners.im.model.orderinfo.ImOperationStatus;

@Data
public class TicketRefund {
    private int partnerOrderId;
    @Deprecated(since = "Use items.buyOperationId")
    private Integer buyOperationId;
    private int checkRefundCounter;
    private String checkDocumentNumber;
    private List<PassengerRefundInfo> items;

    @JsonIgnore
    public Money calculateActualRefundSum() {
        return getRefundedItems().stream()
                .map(PassengerRefundInfo::calculateActualRefundSum)
                .reduce(Money::add).orElse(Money.of(0, ProtoCurrencyUnit.RUB));
    }

    @JsonIgnore
    public List<PassengerRefundInfo> getRefundedItems() {
        return items.stream().filter(x -> x.getRefundOperationStatus() == ImOperationStatus.OK)
                .collect(Collectors.toList());
    }

    @JsonIgnore
    public List<Integer> getBuyOperationIds() {
        List<Integer> buyOperationIds = items.stream().map(PassengerRefundInfo::getBuyOperationId)
                .filter(Objects::nonNull)
                .distinct().collect(Collectors.toList());
        if (buyOperationIds.size() == 0 && buyOperationId != null) {
            return List.of(buyOperationId);
        }
        return buyOperationIds;
    }
}
