package ru.yandex.travel.train.partners.im;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;

import ru.yandex.travel.train.partners.im.model.AutoReturnRequest;
import ru.yandex.travel.train.partners.im.model.AutoReturnResponse;
import ru.yandex.travel.train.partners.im.model.ElectronicRegistrationRequest;
import ru.yandex.travel.train.partners.im.model.ElectronicRegistrationResponse;
import ru.yandex.travel.train.partners.im.model.OrderReservationBlankRequest;
import ru.yandex.travel.train.partners.im.model.OrderReservationTicketBarcodeRequest;
import ru.yandex.travel.train.partners.im.model.OrderReservationTicketBarcodeResponse;
import ru.yandex.travel.train.partners.im.model.ReservationConfirmResponse;
import ru.yandex.travel.train.partners.im.model.ReservationCreateRequest;
import ru.yandex.travel.train.partners.im.model.ReservationCreateResponse;
import ru.yandex.travel.train.partners.im.model.ReturnAmountRequest;
import ru.yandex.travel.train.partners.im.model.ReturnAmountResponse;
import ru.yandex.travel.train.partners.im.model.UpdateBlanksResponse;
import ru.yandex.travel.train.partners.im.model.insurance.InsuranceCheckoutRequest;
import ru.yandex.travel.train.partners.im.model.insurance.InsuranceCheckoutResponse;
import ru.yandex.travel.train.partners.im.model.insurance.InsurancePricingRequest;
import ru.yandex.travel.train.partners.im.model.insurance.InsurancePricingResponse;
import ru.yandex.travel.train.partners.im.model.insurance.InsuranceReturnRequest;
import ru.yandex.travel.train.partners.im.model.insurance.InsuranceReturnResponse;
import ru.yandex.travel.train.partners.im.model.orderinfo.OrderInfoResponse;
import ru.yandex.travel.train.partners.im.model.orderlist.OrderListRequest;
import ru.yandex.travel.train.partners.im.model.orderlist.OrderListResponse;

import static ru.yandex.travel.train.partners.im.ImClientHelpers.sync;

public interface ImClient {
    AutoReturnResponse autoReturn(AutoReturnRequest request);

    ElectronicRegistrationResponse changeElectronicRegistration(ElectronicRegistrationRequest request);

    ReturnAmountResponse getReturnAmount(ReturnAmountRequest request);

    InsuranceCheckoutResponse insuranceCheckout(InsuranceCheckoutRequest request);

    InsurancePricingResponse insurancePricing(InsurancePricingRequest request);

    InsuranceReturnResponse insuranceReturn(InsuranceReturnRequest request);

    default CompletableFuture<OrderInfoResponse> orderInfoAsync(int orderId) {
        return orderInfoAsync(orderId, null);
    }

    CompletableFuture<OrderInfoResponse> orderInfoAsync(int orderId, Duration timeout);

    OrderListResponse orderList(OrderListRequest request);


    CompletableFuture<byte[]> orderReservationBlankAsync(OrderReservationBlankRequest request, Duration timeout);

    void reservationCancel(int orderId);

    ReservationConfirmResponse reservationConfirm(int orderId);

    ReservationCreateResponse reservationCreate(ReservationCreateRequest request, Object data);

    UpdateBlanksResponse updateBlanks(int orderItemId, Duration timeout);

    default UpdateBlanksResponse updateBlanks(int orderItemId) {
        return updateBlanks(orderItemId, null);
    }

    default OrderInfoResponse orderInfo(int orderId) {
        return sync(orderInfoAsync(orderId));
    }

    default OrderInfoResponse orderInfo(int orderId, Duration timeout) {
        return sync(orderInfoAsync(orderId, timeout));
    }

    default byte[] orderReservationBlank(OrderReservationBlankRequest request, Duration timeout) {
        return sync(orderReservationBlankAsync(request, timeout));
    }

    default CompletableFuture<byte[]> orderReservationBlankAsync(OrderReservationBlankRequest request) {
        return orderReservationBlankAsync(request, null);
    }

    CompletableFuture<OrderReservationTicketBarcodeResponse> orderReservationTicketBarcodeAsync(OrderReservationTicketBarcodeRequest request, Duration timeout);

    default OrderReservationTicketBarcodeResponse orderReservationTicketBarcode(OrderReservationTicketBarcodeRequest request, Duration timeout) {
        return sync(orderReservationTicketBarcodeAsync(request, timeout));
    }
}
