package ru.yandex.travel.train.partners.im;

import java.util.Arrays;
import java.util.stream.Collectors;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.opentracing.Tracer;
import org.asynchttpclient.Dsl;
import org.slf4j.LoggerFactory;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;

public class ImClientConfigurationHelper {
    public static AsyncHttpClientWrapper createImAhcClient(Tracer tracer) {
        return new AsyncHttpClientWrapper(Dsl.asyncHttpClient(Dsl.config()
                .setThreadFactory(new ThreadFactoryBuilder().setDaemon(true).build()) //TODO move out the Ahc client and close it properly
                .setThreadPoolName("imAhcPool")
                .build()),
                LoggerFactory.getLogger("ru.yandex.travel.orders.partners.im.HttpLogger"),
                "im",
                tracer,
                Arrays.stream(DefaultImClient.Method.values()).map(Enum::toString).collect(Collectors.toSet()));
    }

    public static ImClient createImClient(ImProperties imProperties, AsyncHttpClientWrapper ahcClient,
                                          CustomerInfoRepository customerInfoRepository) {
        ImClient client = new DefaultImClient(
            ahcClient,
            imProperties.getPos(),
            imProperties.getHttpRequestTimeout(),
            imProperties.getBaseUrl(),
            imProperties.getLogin(),
            imProperties.getPassword()
        );
        if (imProperties.getTestCases() != null && imProperties.getTestCases().isEnabled()) {
            client = new TestCaseInterceptorImClient(imProperties, client, customerInfoRepository);
        }
        return client;
    }
}
