package ru.yandex.travel.train.partners.im;

import java.util.ArrayList;
import java.util.List;

public class ImClientException extends RuntimeException {
    private int code;
    private List<String> messageParams;

    public ImClientException(int code, String message, List<String> messageParams)
    {
        super(message);
        this.code = code;
        this.messageParams = messageParams;
    }

    public ImClientException(int code, String message)
    {
        super(message);
        this.code = code;
        this.messageParams = new ArrayList<>();
    }

    public ImClientException(int code, String message, Throwable cause)
    {
        super(message, cause);
        this.code = code;
        this.messageParams = new ArrayList<>();
    }

    public int getCode() { return code; }

    @Override
    public String toString() {
        if (code != 0) {
            return String.format("Im error imCode=%s. %s", code, super.toString());
        } else {
            return super.toString();
        }
    }

    public List<String> getMessageParams() {
        return messageParams;
    }
}
