package ru.yandex.travel.train.partners.im;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ImClientHelpers {
    static <T> T sync(CompletableFuture<T> future) {
        try {
            return future.get();
        } catch (InterruptedException e) {
            log.error("Im call interrupted", e);
            Thread.currentThread().interrupt(); // preserved interruption status
            throw new ImClientRetryableException("Im call interrupted", e);
        } catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ImClientException) {
                throw (ImClientException) cause;
            } else if (cause instanceof TimeoutException) {
                throw new ImClientIOException("Im call timeout", e);
            } else if (cause instanceof IOException) {
                throw new ImClientIOException("Im call io error", e);
            } else {
                throw new RuntimeException(e);
            }
        }
    }
}

