package ru.yandex.travel.train.partners.im;

import java.time.Duration;

import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class ImProperties {
    @NotNull
    private String pos;

    @NotNull
    private String login;

    @NotNull
    private String password;

    @NotNull
    private String baseUrl;

    @NotNull
    private Duration httpReadTimeout;

    @NotNull
    private Duration httpRequestTimeout;

    private TestCases testCases;

    @Getter
    @Setter
    public static class TestCases {
        private boolean enabled;

        private String mockImFirstName;
        private PointcutMiddleName pointcutMiddleName;
        private ErrorsLastName errorsLastName;
    }

    @Getter
    @Setter
    public static class PointcutMiddleName {
        private String reservationCreate;
        private String reservationConfirm;
        private String insuranceStatus;
        private String insurancePricing;
        private String insuranceCheckout;
    }

    @Getter
    @Setter
    public static class ErrorsLastName {
        private String throwTimeout;
        private String throwCode2;
        private String throwCode3;
        private String throwNoSeats;
        private String statusError;
        private String statusInProgress;
    }
}
