package ru.yandex.travel.train.partners.im.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum ImBlankStatus {
    NO_REMOTE_CHECK_IN(0, "ElectronicRegistrationAbsent"),
    REMOTE_CHECK_IN(1, "ElectronicRegistrationPresent"),
    PAYMENT_NOT_CONFIRMED(2, "NotConfirmed"),
    CANCELLED(3, "Voided"),
    REFUNDED(4, "Returned"),
    PLACES_REFUNDED(5, "PlacesReturned"),
    STRICT_BOARDING_PASS(6, "VoucherIssued"),
    // RESERVATION(7, ""), It looks like for IM it will be "NotConfirmed" too.
    INTERRUPTED(8, "TripWasInterrupted"),
    RESUMED(9, "TripWasInterruptedAndResumedAfter"),
    UNKNOWN(20, "Unknown");

    private final int expressStatusId;
    private final String value;

    @JsonCreator
    public static ImBlankStatus fromString(String val) {
        for (ImBlankStatus candidate : ImBlankStatus.values()) {
            if (candidate.getValue().equalsIgnoreCase(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Don't know how to map value %s to enum ImOperationStatus", val)
        );
    }

    public int getExpressStatusId() {
        return expressStatusId;
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
