package ru.yandex.travel.train.partners.im.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum PendingElectronicRegistration {
    NO_VALUE("NoValue"), TO_CANCEL("ToCancel");

    private final String value;

    @JsonCreator
    public static PendingElectronicRegistration fromString(String val) {
        for (PendingElectronicRegistration candidate : PendingElectronicRegistration.values()) {
            if (candidate.getValue().equalsIgnoreCase(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Don't know how to map value %s to enum PendingElectronicRegistration", val)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
