package ru.yandex.travel.train.partners.im.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import ru.yandex.travel.train.model.PassengerCategory;

@Data
public class RailwayPassengerRequest {
    private PassengerCategory category;
    private int orderCustomerIndex;
    private String preferredAdultTariffType;
    @JsonInclude(JsonInclude.Include.ALWAYS)
    private List<RailwayCardInfo> railwayBonusCards;
    private String phone;
    private String contactEmailOrPhone;
    @JsonProperty("IsMarketingNewsletterAllowed")
    private boolean marketingNewsletterAllowed = false;
    @JsonProperty("IsNonRefundableTariff")
    private boolean nonRefundableTariff;
    @JsonProperty("IsInvalid")
    private boolean isInvalid;
    private String disabledPersonId;
    private String transitDocument;
}
