package ru.yandex.travel.train.partners.im.model;

import java.time.LocalDateTime;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.Data;

import ru.yandex.travel.train.model.AdditionalPlaceRequirements;
import ru.yandex.travel.train.model.CabinGenderKind;
import ru.yandex.travel.train.model.CabinPlaceDemands;
import ru.yandex.travel.train.model.CarStorey;
import ru.yandex.travel.train.model.CarType;

@Data
@JsonPropertyOrder(value = {"$type"})
public class RailwayReservationRequest {
    @JsonProperty("$type")
    private String objType = "ApiContracts.Railway.V1.Messages.Reservation.RailwayReservationRequest, ApiContracts";
    private String providerPaymentForm = "Card";
    private boolean setElectronicRegistration;
    private List<RailwayPassengerRequest> passengers;
    private int index;
    private AdditionalPlaceRequirements additionalPlaceRequirements;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Boolean bedding;
    private boolean onRequestMeal;
    private CabinGenderKind cabinGenderKind;
    private CabinPlaceDemands cabinPlaceDemands;
    private String carNumber;
    private CarStorey carStorey;
    private CarType carType;
    private LocalDateTime departureDate;
    private String destinationCode;
    private boolean giveAdditionalTariffForChildIfPossible;
    private String internationalServiceClass;
    private String specialPlacesDemand;
    private Integer lowerPlaceQuantity;
    private Integer upperPlaceQuantity;
    private String originCode;
    private PlaceRange placeRange;
    private String serviceClass;
    private String trainNumber;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Double clientCharge;
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private String provider;
}
