package ru.yandex.travel.train.partners.im.model;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import ru.yandex.travel.train.model.CarType;

@Data
public class RailwayReservationResponse {
    @JsonProperty("$type")
    private String objType = "ApiContracts.Railway.V1.Messages.Reservation.RailwayReservationResponse, ApiContracts";
    private BigDecimal amount;
    private LocalDateTime arrivalDateTime;
    private List<RailwayReservationBlankResponse> blanks;
    private String carDescription;
    private String carNumber;
    private CarType carType;
    private String carrier;
    private String carrierCode;
    private String carrierTin;
    private LocalDateTime confirmTill;
    private String countryCode;
    private LocalDateTime departureDateTime;
    private String destinationStation;
    private String destinationStationCode;
    private int destinationTimeZoneDifference;
    private int index;
    private String internationalServiceClass;
    @JsonProperty("IsSuburban")
    private boolean isSuburban;
    @JsonProperty("IsOnlyFullReturnPossible")
    private boolean isOnlyFullReturnPossible;
    private LocalDateTime localArrivalDateTime;
    private LocalDateTime localDepartureDateTime;
    private int orderItemId;
    private String originStation;
    private String originStationCode;
    private int originTimeZoneDifference;
    private List<RailwayPassengerResponse> passengers;
    private String serviceClass;
    private String trainDescription;
    private String trainNumber;
    private String timeDescription;
    private int tripDuration;
}
