package ru.yandex.travel.train.partners.im.model.orderinfo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum BoardingSystemType {
    NO_VALUE("NoValue"),
    ELECTRONIC_TICKET_CONTROL("ElectronicTicketControl"),
    PASSENGER_BOARDING_CONTROL("PassengerBoardingControl");

    private final String value;

    @JsonCreator
    public static BoardingSystemType fromString(String val) {
        if (val == null) {
            return null;
        }
        for (BoardingSystemType candidate : BoardingSystemType.values()) {
            if (candidate.getValue().equalsIgnoreCase(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Don't know how to map value %s to enum BoardingSystemType", val)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
