package ru.yandex.travel.train.partners.im.model.orderinfo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum ImOperationStatus {
    OK("Succeeded"),
    IN_PROCESS("InProcess"),
    FAILED("Error");

    private final String value;

    @JsonCreator
    public static ImOperationStatus fromString(String val) {
        for (ImOperationStatus candidate : ImOperationStatus.values()) {
            if (candidate.getValue().equalsIgnoreCase(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Don't know how to map value %s to enum ImOperationStatus", val)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
