package ru.yandex.travel.train.partners.im.model.orderinfo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum ImOperationType {
    BUY("Purchase"),
    REFUND("Return");

    private final String value;

    @JsonCreator
    public static ImOperationType fromString(String val) {
        for (ImOperationType candidate : ImOperationType.values()) {
            if (candidate.getValue().equalsIgnoreCase(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Don't know how to map value %s to enum ImOperationType", val)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
