package ru.yandex.travel.train.partners.im.model.orderinfo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum ImOrderItemType {
    RAILWAY("ApiContracts.Order.V1.Info.OrderItem.Railway.RailwayFullOrderItemInfo, ApiContracts"),
    INSURANCE("ApiContracts.Order.V1.Info.OrderItem.Insurance.RailwayInsuranceFullOrderItemInfo, ApiContracts"),
    SUBURBAN("ApiContracts.Order.V1.Info.OrderItem.Railway.RailwaySuburbanFullOrderItemInfo, ApiContracts");

    private final String value;

    @JsonCreator
    public static ImOrderItemType fromString(String val) {
        for (ImOrderItemType candidate : ImOrderItemType.values()) {
            if (candidate.getValue().equalsIgnoreCase(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Don't know how to map value %s to enum ImOperationType", val)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
