package ru.yandex.travel.train.partners.im.model.orderinfo;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

@Data
public class OrderInfoResponse {
    private List<OrderItemResponse> orderItems;

    public List<OrderItemResponse> findBuyRailwayItems() {
        return orderItems.stream()
                .filter(i -> (ImOrderItemType.RAILWAY == i.getType()) && (ImOperationType.BUY == i.getOperationType()))
                .collect(Collectors.toList());
    }

    public OrderItemResponse findItem(int orderItemId) {
        return orderItems.stream()
                .filter(i -> i.getOrderItemId() == orderItemId)
                .findFirst().orElse(null);
    }

    public List<OrderItemResponse> findItems(Collection<Integer> orderItemIds) {
        var set = Set.copyOf(orderItemIds);
        return orderItems.stream()
                .filter(i -> set.contains(i.getOrderItemId()))
                .collect(Collectors.toList());
    }

    public List<OrderItemResponse> findBuyInsuranceItems() {
        return orderItems.stream()
                .filter(i -> (ImOrderItemType.INSURANCE == i.getType()) && (ImOperationType.BUY == i.getOperationType()))
                .collect(Collectors.toList());
    }

    public List<OrderItemResponse> findRefundInsuranceItems() {
        return orderItems.stream()
                .filter(i -> (ImOrderItemType.INSURANCE == i.getType()) && (ImOperationType.REFUND == i.getOperationType()))
                .collect(Collectors.toList());
    }

    public List<OrderItemResponse> findRefundRailwayItems() {
        return orderItems.stream()
                .filter(i -> (ImOrderItemType.RAILWAY == i.getType()) && (ImOperationType.REFUND == i.getOperationType()))
                .sorted(Comparator.comparing(OrderItemResponse::getMskCreatedAt))
                .collect(Collectors.toList());
    }

    @JsonIgnore
    public Map<Integer, OrderItemBlank> getBlankIdToBlankMap() {
        return findBuyRailwayItems().stream()
                .flatMap(x -> x.getOrderItemBlanks().stream())
                .collect(Collectors.toMap(OrderItemBlank::getOrderItemBlankId, b -> b ));
    }
}
