package ru.yandex.travel.train.partners.im.model.orderinfo;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

@Data
public class OrderItemResponse {
    private int orderItemId;

    @JsonProperty("$type")
    private ImOrderItemType type;

    private ImOperationType operationType;
    private ImOperationStatus simpleOperationStatus;
    private String reservationNumber;

    private LocalDateTime electronicRegistrationExpirationDateTime;

    private BoardingSystemType boardingSystemType;

    @JsonProperty("CreateDateTime")
    private LocalDateTime mskCreatedAt;

    @JsonProperty("ConfirmTimeLimit")
    private LocalDateTime mskReservedTo;

    @JsonProperty("ConfirmDateTime")
    private LocalDateTime mskConfirmedAt;

    @JsonProperty("IsExternallyLoaded")
    private Boolean isExternallyLoaded;
    private String agentReferenceId;
    private Integer previousOrderItemId;
    private BigDecimal amount;

    private List<OrderItemBlank> orderItemBlanks;

    private List<OrderItemCustomer> orderItemCustomers;

    @JsonIgnore
    public Map<Integer, OrderItemBlank> getIdToBlankMap() {
        return orderItemBlanks.stream().collect(Collectors.toMap(OrderItemBlank::getOrderItemBlankId, b -> b ));
    }
}
