package ru.yandex.travel.train.partners.im.model.orderlist;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum ImShortOrderItemType {
    RAILWAY("ApiContracts.Order.V1.Info.OrderItem.Railway.RailwayShortOrderItemInfo, ApiContracts"),
    INSURANCE("ApiContracts.Order.V1.Info.OrderItem.Insurance.InsuranceShortOrderItemInfo, ApiContracts");

    private final String value;

    @JsonCreator
    public static ImShortOrderItemType fromString(String val) {
        for (ImShortOrderItemType candidate : ImShortOrderItemType.values()) {
            if (candidate.getValue().equalsIgnoreCase(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Don't know how to map value %s to enum ShortOrderItemType", val)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
