# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import smtplib
from email import encoders
from email.mime.base import MIMEBase
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
from email.utils import formatdate


class MailSender(object):
    def __init__(self, host, from_email):
        self._mail_host = host
        self._from_email = from_email

    def send_email(self, to_emails, subject, body, files=None):
        msg = MIMEMultipart()

        msg['From'] = self._from_email
        msg['To'] = ', '.join(to_emails)
        msg['Date'] = formatdate(localtime=True)

        msg['Subject'] = subject
        msg.attach(MIMEText(body, 'html', _charset='utf-8'))
        if files:
            self._attach_contents(msg, files)

        server = smtplib.SMTP(self._mail_host)
        server.sendmail(self._from_email, to_emails, msg.as_string())
        server.quit()

    def _attach_contents(self, msg, files):
        for name, content in files:
            attachment = MIMEBase('application', 'octet-stream')

            attachment.set_payload(content)
            encoders.encode_base64(attachment)
            attachment.add_header(
                'Content-Disposition',
                'attachment',
                # Важно! пишем имена файлов только в латинице, так как у @zharik под win 8 клиент не понимает utf-8
                filename=name,
            )
            msg.attach(attachment)
