# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os

from travel.library.python.base_http_client import BaseHttpClient, RetryConfig


class DeployPublicApiClient(BaseHttpClient):
    RETRY_CONFIG = RetryConfig(total=2)
    DISABLE_CIRCUIT_BREAKER_CONFIG = True
    TIMEOUT = 0.05

    def __init__(self, host='http://localhost:1/', **kwargs):
        super(DeployPublicApiClient, self).__init__(host=host, **kwargs)

    @staticmethod
    def get_current_box_id():
        return os.getenv('DEPLOY_BOX_ID')

    def get_pod_attributes(self):
        return self.get('pod_attributes').json()

    def get_current_box_requirements(self):
        pod_attrs = self.get_pod_attributes()
        all_box_requirements = pod_attrs['box_resource_requirements']
        box_requirements = all_box_requirements.get(DeployPublicApiClient.get_current_box_id())
        return box_requirements
