# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from travel.rasp.library.python.api_clients.dzv.serialization import parse_platforms
from travel.library.python.base_http_client import BaseHttpClient, RetryConfig, CircuitBreakerConfig


log = logging.getLogger(__name__)


class DzvClient(BaseHttpClient):
    """
    Клиент АПИ ДЖВ
    http://cmsapi.indigointeractive.ru/yandex/doc.html#faq
    https://st.yandex-team.ru/RASPFRONT-9690
    """
    HTTP_CLIENT_NAME = 'DZV'
    RETRY_CONFIG = RetryConfig(total=3)
    CIRCUIT_BREAKER_CONFIG = CircuitBreakerConfig(fail_max=3, reset_timeout=25)
    MASKED_PARAMS = {'key'}

    def __init__(self, host, key, **kwargs):
        self.key = key
        super(DzvClient, self).__init__(host, **kwargs)

    def get_platforms(self, term_id, timeout=None):
        params = {
            'method': 'rasp',
            'term_id': term_id,
            'key': self.key,
        }
        response = self.get(
            '',
            params=params,
            timeout=timeout
        )

        return parse_platforms(response.content)
