# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from typing import AnyStr, Union


class Env(object):
    def __init__(self, name, serv_id):
        self.name = name
        self.id = serv_id


class Service(object):
    def __init__(self, name, serv_id, namespace):
        self.name = name
        self.id = serv_id
        self.namespace = namespace
        self.envs_by_name = {}
        self.envs_by_id = {}

    def add_env(self, env_name, env_id):
        if env_name in self.envs_by_name:
            raise Exception(env_name)

        if env_id in self.envs_by_id:
            raise Exception(env_id)

        env = Env(env_name, env_id)
        self.envs_by_name[env_name] = env
        self.envs_by_id[env_id] = env

    def get_envs(self):
        return self.envs_by_name.values()

    def __str__(self):
        return self.name + ': ' + ', '.join(self.envs_by_name.keys())


class Services(object):
    def __init__(self, namespace='travel'):
        self.namespace = namespace
        self.by_name = {}
        self.by_id = {}

    def add(self, name, serv_id):
        if name in self.by_name:
            raise Exception('Services with same name: {} [{}, {}]'.format(name, self.by_name[name].id, serv_id))

        if serv_id in self.by_id:
            raise Exception('Services with same id: {} [{}, {}]'.format(serv_id, self.by_id[serv_id].name, name))

        service = Service(name, serv_id, self.namespace)
        self.by_name[name] = service
        self.by_id[serv_id] = service

    def get(self, name_or_id):
        # type: (Union[AnyStr, int]) -> Service
        if isinstance(name_or_id, int):
            return self.by_id.get(name_or_id)
        else:
            return self.by_name.get(name_or_id)

    def __iter__(self):
        return iter(self.by_name.values())
