# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from travel.library.python.base_http_client import BaseHttpClient, RetryConfig, CircuitBreakerConfig

JUGGLER_HOST = 'http://juggler-push.search.yandex.net'

log = logging.getLogger(__name__)


class JugglerClient(BaseHttpClient):
    HTTP_CLIENT_NAME = 'JUGGLER'
    RETRY_CONFIG = RetryConfig(total=2, backoff_factor=0.1, method_whitelist=['POST'])
    CIRCUIT_BREAKER_CONFIG = CircuitBreakerConfig(fail_max=3, reset_timeout=5)
    TIMEOUT = 5

    def __init__(self, host=JUGGLER_HOST, source=None, **kwargs):
        self.source = source
        super(JugglerClient, self).__init__(host, **kwargs)

    def send(self, events, source=None):
        data = {
            'source' : source or self.source,
            'events' : events
        }

        try:
            result = self.post('/events', json=data)
        except Exception:
            log.exception('JuggerClient error:')  # it also prints traceback
            return False

        message = result.json()
        for idx, res_event in enumerate(message.get('events', [])):
            if res_event.get('code') == 200:
                continue
            event = events[idx] if idx < len(events) else None
            log.error('JuggerClient partial error response with req "%s" and res "%s"', str(event), str(res_event))

        return True
