# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from lxml import etree

from travel.library.python.base_http_client import BaseHttpClient, RetryConfig


parser = etree.XMLParser(huge_tree=True)


class KrasnodarBusClient(BaseHttpClient):
    HTTP_CLIENT_NAME = 'KrasnodarBus'
    RETRY_CONFIG = RetryConfig(total=3)
    DISABLE_CIRCUIT_BREAKER_CONFIG = True
    MASKED_PARAMS = {'passw'}

    def __init__(self, host,  login, password, **kwargs):
        super(KrasnodarBusClient, self).__init__(host=host, **kwargs)
        self._login = login
        self._password = password

    def call_and_parse(self, params):
        response = self.get(
            'cgi-bin/sale.cgi',
            params=params
        )
        return etree.fromstring(response.content, parser=parser)

    def dest(self, kodp):
        params = {
            'act': 'dest',
            'kodp': kodp,
            'login': self._login,
            'passw': self._password
        }
        return self.call_and_parse(params)

    def reis(self, dt, kodp, kpp):
        params = {
            'act': 'reis',
            'login': self._login,
            'passw': self._password,
            'date': dt.strftime('%d.%m.%y'),
            'kodp': kodp,
            'kpp': kpp
        }
        return self.call_and_parse(params)
