# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from travel.library.python.base_http_client import BaseHttpClient, RetryConfig, CircuitBreakerConfig


log = logging.getLogger(__name__)


class MarketCmsClient(BaseHttpClient):
    """
    Клиент CMS Яндекс.Маркет
    """
    HTTP_CLIENT_NAME = 'MARKET_CMS'
    RETRY_CONFIG = RetryConfig(total=3)
    CIRCUIT_BREAKER_CONFIG = CircuitBreakerConfig(fail_max=3, reset_timeout=60)
    TIMEOUT = 10

    def __init__(self, host, **kwargs):
        super(MarketCmsClient, self).__init__(host, **kwargs)

    """
    Example:
    http://templator.vs.market.yandex.net:29338/tarantino/getcontextpage?device=desktop&format=json&type=travel_article,travel_tag,travel_journal&zoom=entrypoints
    """
    def get_context_page(self, timeout=None):
        params = {
            'device': 'desktop',
            'format': 'json',
            'type': 'travel_article,travel_tag,travel_journal',
            'zoom': 'entrypoints',
        }
        response = self.get(
            '/tarantino/getcontextpage',
            params=params,
            timeout=timeout
        )

        return response.json()['result']
