# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
from typing import AnyStr, Optional

from travel.library.python.tracing.instrumentation import traced_function
from travel.library.python.base_http_client import BaseHttpClient


log = logging.getLogger(__name__)


class RedirClient(BaseHttpClient):
    HTTP_CLIENT_NAME = 'Redir'

    @traced_function
    def suburban_label_to_hash(self, serialized_label):
        # type: (AnyStr) -> Optional[AnyStr]

        return self.get(
            'suburban/label_to_hash/',
            params={'LabelParams': serialized_label}
        ).text
