# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.library.python.base_http_client import BaseHttpClient, RetryConfig
from travel.rasp.library.python.api_clients.ticket_daemon.jsend import process_errors, read


class TicketDaemonClient(BaseHttpClient):
    RETRY_CONFIG = RetryConfig(total=3)

    def __init__(self, host, **kwargs):
        super(TicketDaemonClient, self).__init__(host, **kwargs)

    def _get_api_response(self, url_path, params):
        response = self.get('/jsendapi/{}'.format(url_path), params=params, check_response_status=False)

        if response.status_code == 204:
            return None

        process_errors(response.json(), response.status_code)

        return read(response.json())

    def init_search(self, params):
        return self._get_api_response('init_search/', params)

    def get_results_by_qid(self, params):
        return self._get_api_response('rasp/results_by_qid/', params)

    def get_results_by_search_params(self, params):
        return self._get_api_response('rasp/results_by_search_params/', params)
