# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import uuid
from typing import AnyStr, List, Optional, Dict


class SuburbanService(object):
    def __init__(
        self, provider, station_from_id, station_to_id, price, carrier_partner, book_data, test_context_token=None
    ):
        # type: (AnyStr, int, int, float, Optional[AnyStr], SuburbanServiceBookData, Optional[AnyStr]) -> None

        self.request_json = {
            'provider': provider,
            'station_from_id': station_from_id,
            'station_to_id': station_to_id,
            'price': price,
            'carrier_partner': carrier_partner,
            'provider_book_data': book_data.to_json()
        }

        if test_context_token:
            self.request_json['test_context_token'] = test_context_token


class SuburbanServiceBookData(object):
    """Базовый класс для book_data разных провадеров"""
    def to_json(self):
        # type: () -> Dict
        raise NotImplementedError


class TravelApiCreateOrderInfo(object):
    def __init__(self, label, phone, email, geo_id, ip, suburban_services, payment_test_context_token=None):
        # type: (AnyStr, AnyStr, AnyStr, int, AnyStr, List[SuburbanService], Optional[AnyStr]) -> None

        self.request_json = {
            'deduplication_key': str(uuid.uuid4()),
            'label': label,
            'contact_info': {
                'phone': phone,
                'email': email,
            },
            'user_info': {
                'ip': ip,
                'geo_id': geo_id,
            },
            'order_history': [],
            'suburban_services': [service.request_json for service in suburban_services],
        }

        if payment_test_context_token:
            self.request_json['payment_test_context_token'] = payment_test_context_token
