# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from typing import Dict, AnyStr

from travel.rasp.library.python.api_clients.travel_api.create_order_info import SuburbanServiceBookData


class ImServiceBookData(SuburbanServiceBookData):
    def __init__(self, date, station_from_express_id, station_to_express_id, train_number, im_provider):
        # type: (AnyStr, int, int, AnyStr, AnyStr) -> None

        self.request_json = {
            'date': date,
            'station_from_express_id': station_from_express_id,
            'station_to_express_id': station_to_express_id,
            'train_number': train_number,
            'im_provider': im_provider
        }

    def to_json(self):
        # type: () -> Dict
        return self.request_json
