# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from typing import AnyStr, Dict

from travel.rasp.library.python.api_clients.travel_api.create_order_info import SuburbanServiceBookData


class WicketTypeCode(object):
    TURNSTILE = 'turnstile'
    VALIDATOR = 'validator'


class WicketDeviceType(object):
    def __init__(self, device_code, wicket_type_code):
        # type: (AnyStr, AnyStr) -> None
        self.device_code = device_code
        self.wicket_type_code = wicket_type_code

    def to_json(self):
        # type: () -> Dict[AnyStr, AnyStr]
        return {
            'type': self.wicket_type_code,
            'device_type': self.device_code
        }


WICKET_TYPES_BY_MOVISTA_CODES = {
    'MID2Tutorial': WicketDeviceType('MID2Turnstile', WicketTypeCode.TURNSTILE),
    'PA2validatorTutorial': WicketDeviceType('PA2Validator', WicketTypeCode.VALIDATOR),
    'validatorTutorial': WicketDeviceType('OldValidator', WicketTypeCode.VALIDATOR),
}


class MovistaServiceBookData(SuburbanServiceBookData):
    def __init__(self, date, station_from_express_id, station_to_express_id, fare_id, wicket_device):
        # type: (AnyStr, int, int, int, WicketDeviceType) -> None

        self.request_json = {
            'date': date,
            'station_from_express_id': station_from_express_id,
            'station_to_express_id': station_to_express_id,
            'fare_id': fare_id,
            'wicket': wicket_device.to_json()
        }

    def to_json(self):
        # type: () -> Dict
        return self.request_json
