# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from django.apps import AppConfig

from common.apps.suburban_events import dynamic_params
from common.db.mysql_info import render_mysql_info
from common.db.switcher import switcher
from common.dev_tools.build import is_building
from common.dynamic_settings.default import storage
from travel.rasp.library.python.common23.date.environment import is_migration_allowed


log = logging.getLogger(__name__)


def log_mysql_configuration():
    """Для любого сервиса полезно на старте зафиксировать, в каком сетапе кластеров мы запустились. """
    try:
        mysql_info_str = render_mysql_info()
    except Exception:
        log.exception("Unable to render_mysql_info")
    else:
        log.info("Mysql configuration: " + mysql_info_str)


class CommonAppConfig(AppConfig):
    name = 'common'
    label = 'common'

    def ready(self):
        if not is_building():
            # чтобы защититься от http://api.mongodb.com/python/current/faq.html#is-pymongo-fork-safe
            if is_migration_allowed():
                storage.setup()
                dynamic_params.setup()

            switcher.sync_db()

            log_mysql_configuration()
