# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
from datetime import timedelta
from functools import partial

from common.apps.archival_data.models import ArchivalSearchData, ArchivalSettlementsData
from travel.rasp.library.python.common23.date.environment import now
from travel.rasp.library.python.common23.logging import log_run_time

log = logging.getLogger(__name__)
log_run_time = partial(log_run_time, logger=log)


OLD_DATA_DAYS = 365


def clean():
    old_date = (now() - timedelta(days=OLD_DATA_DAYS)).date()

    with log_run_time('clean ArchivalSettlementsData older than {}'.format(old_date)):
        log.info('count: {}'.format(ArchivalSettlementsData.objects.filter(update_dt__lte=old_date).delete()))

    with log_run_time('clean ArchivalSearchData older than {}'.format(old_date)):
        log.info('count: {}'.format(ArchivalSearchData.objects.filter(update_dt__lte=old_date).delete()))
