# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from mongoengine import IntField, StringField, DateTimeField, DictField, EmbeddedDocumentListField, EmbeddedDocument
from six import python_2_unicode_compatible

from common.db.mongo.base import RaspDocument


@python_2_unicode_compatible
class ArchivalSearchData(RaspDocument):
    point_from = StringField(required=True, null=False)
    point_to = StringField(required=True, null=False)
    update_dt = DateTimeField(required=True, null=False)
    transport_type = IntField(required=True, null=False)

    meta = {
        'indexes': [
            {
                'fields': ['point_from', 'point_to', 'transport_type'],
                'name': 'point_index'
            },
            'update_dt'
        ],
        'index_background': True,
        'strict': False
    }

    def __str__(self):
        return '{}__{}__{}'.format(self.point_from, self.point_to, self.transport_type)

    def __repr__(self):
        return self.__str__()


@python_2_unicode_compatible
class SegmentData(EmbeddedDocument):
    title = StringField()
    arrival = DateTimeField()
    departure = DateTimeField()
    station_from = DictField()
    station_to = DictField()
    run_days_by_tz = DictField()
    transport_type = DictField()
    thread = DictField()

    def __str__(self):
        return '{} {: <9} {} ({})  {}'.format(
            self.station_key,
            self.type,
            self.dt_fact,
            self.dt_normative,
            self.weight
        )

    meta = {
        'index_background': True,
        'strict': False
    }


@python_2_unicode_compatible
class ArchivalSettlementsData(RaspDocument):
    point_from = StringField(required=True, null=False)
    point_to = StringField(required=True, null=False)
    transport_type = IntField(required=True, null=False)
    update_dt = DateTimeField(required=True, null=False)

    segments = EmbeddedDocumentListField(SegmentData)

    meta = {
        'indexes': [
            {
                'fields': ['point_from', 'point_to', 'transport_type', 'update_dt'],
                'name': 'settlement_transport_dt_index'
            },
            'update_dt'
        ],
        'index_background': True,
        'strict': False
    }

    def __str__(self):
        return '{}__{}__{}'.format(self.point_from, self.point_to, self.transport_type)

    def __repr__(self):
        return self.__str__()
