# coding: utf8
from common.apps.facility.models import SuburbanFacility
from common.tester.factories import ModelFactory, factories


class SuburbanFacilityFactory(ModelFactory):
    Model = SuburbanFacility

    default_kwargs = {
        'title_ru': u'НазваниеУдобства',
        'code': lambda: SuburbanFacilityFactory.gen_code(),
        'order': lambda: SuburbanFacilityFactory.gen_order(),
    }

    @classmethod
    def gen_code(cls):
        cls.code_counter = getattr(cls, 'code_counter', 0) + 1
        return u'CODE_{}'.format(cls.code_counter)

    @classmethod
    def gen_order(cls):
        cls.order_counter = getattr(cls, 'order_counter', 0) + 1
        return cls.order_counter


factories[SuburbanFacility] = create_suburban_facility = SuburbanFacilityFactory()
