# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import common.utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('www', '__first__'),
    ]

    operations = [
        migrations.CreateModel(
            name='SuburbanFacility',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('icon', models.FileField(default=None, upload_to='data/facility/suburban-facility', null=True, verbose_name='иконка в svg', blank=True)),
                ('title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, verbose_name='название (ru)')),
                ('title_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='название (en)', blank=True)),
                ('title_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='название (tr)', blank=True)),
                ('title_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='название (uk)', blank=True)),
            ],
            options={
                'verbose_name': 'Удобство электричек',
                'verbose_name_plural': 'Удобства электричек',
            },
        ),
        migrations.CreateModel(
            name='SuburbanThreadFacility',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('year_days', common.utils.fields.ThreadCalendarField(default=b'000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000', verbose_name='дни хождения во временной зоне нитки')),
                ('facilities', models.ManyToManyField(to='facility.SuburbanFacility', blank=True)),
                ('thread', models.ForeignKey(to='www.RThread')),
            ],
            options={
                'verbose_name': 'Удобство электричек в нитке',
                'verbose_name_plural': 'Удобства электричек в нитке',
            },
        ),
    ]
