# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import common.utils.fields
import django.core.validators


class Migration(migrations.Migration):

    dependencies = [
        ('facility', '0001_initial'),
    ]

    operations = [
        migrations.AddField(
            model_name='suburbanfacility',
            name='code',
            field=common.utils.fields.CodeCharField(default='', max_length=100, validators=[django.core.validators.RegexValidator('[a-z][_a-z0-9]*', 'Код должен содержать только латинкие буквы и цифры и знак "_"')], unique=True),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='suburbanfacility',
            name='icon',
            field=models.FileField(default='', upload_to='data/facility/suburban-facility', verbose_name='иконка в svg'),
            preserve_default=False,
        ),
    ]
