# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import common.utils.fields
import django.core.validators


class Migration(migrations.Migration):

    dependencies = [
        ('facility', '0002_facility_code_icon_notnull'),
    ]

    operations = [
        migrations.AddField(
            model_name='suburbanfacility',
            name='order',
            field=models.IntegerField(default=0),
        ),
        migrations.AlterField(
            model_name='suburbanfacility',
            name='code',
            field=common.utils.fields.CodeCharField(unique=True, max_length=100, validators=[django.core.validators.RegexValidator('[a-z][_a-z0-9]*', 'Код должен содержать только латинские буквы и цифры и знак "_"')]),
        ),
    ]
