# coding: utf-8
from __future__ import unicode_literals

from django.core.validators import RegexValidator
from django.db import models
from django.utils import six
from django.utils.translation import ugettext_lazy as _

from common.db.mds.s3_storage import mds_s3_media_storage
from common.models_utils.i18n import L_field
from common.utils.date import RunMask
from common.utils.fields import ThreadCalendarField, CodeCharField


@six.python_2_unicode_compatible
class SuburbanFacility(models.Model):
    L_title = L_field(_('название'), base_lang='ru', base_field_critical=True)
    icon = models.FileField(verbose_name=_('иконка в svg'),
                            storage=mds_s3_media_storage,
                            upload_to='data/facility/suburban-facility',
                            null=False, blank=False)
    code = CodeCharField(max_length=100, validators=[
        RegexValidator(r'[a-z][_a-z0-9]*', 'Код должен содержать только латинские буквы и цифры и знак "_"')
    ], unique=True)
    order = models.IntegerField(blank=False, null=False, default=0)

    def __str__(self):
        return self.title_ru

    class Meta:
        verbose_name = _('Удобство электричек')
        verbose_name_plural = _('Удобства электричек')


class SuburbanThreadFacility(models.Model):
    thread = models.ForeignKey('www.RThread', null=False, blank=False, unique=True)
    year_days = ThreadCalendarField(verbose_name=_(u'дни хождения во временной зоне нитки'),
                                    default=RunMask.EMPTY_YEAR_DAYS)
    facilities = models.ManyToManyField('facility.SuburbanFacility', blank=True)

    class Meta:
        verbose_name = _('Удобство электричек в нитке')
        verbose_name_plural = _('Удобства электричек в нитке')
