# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.dynamic_settings.core import DynamicSetting
from common.dynamic_settings.default import conf
from common.settings.configuration import Configuration
from common.settings.utils import define_setting


conf.register_settings(
    SUBURBAN_NOTIFY_OLD_DAYS=DynamicSetting(14, cache_time=600, description='Сколько дней хранить изменения'),
    SUP_DEFAULT_DEVICE_ID_POLICY=DynamicSetting(
        'suburban_default_d8_device_id',
        cache_time=10 * 60,
        description='Политика обычного пуша. Идентификатор лимита уведомлений при адресации по did'
    ),
    SUP_URGENT_DEVICE_ID_POLICY=DynamicSetting(
        'suburban_urgent_d4_device_id',
        cache_time=10 * 60,
        description='Политика экстренного пуша. Идентификатор лимита уведомлений при адресации по did'
    ),
    SUP_INSTALL_ID_POLICY=DynamicSetting(
        'suburban_h6_d14_install_id',
        cache_time=10 * 60,
        description='Политика пуша. Идентификатор лимита уведомлений при адресации по uuid'
    )
)

define_setting('INFOCENTER_URL', {
    'production': 'https://infocenter.rasp.yandex-team.ru/',
    'testing': 'https://infocenter.tst.rasp.yandex-team.ru/',
}, default='')

define_setting('INFO_CENTER_ID_COUNTER', default='info_center_int_id')
define_setting('YADM_NEWS_ITEM_ID_COUNTER', default='yadm_news_item_int_id')

define_setting(
    'SUBURBAN_APP_IDS',
    {Configuration.PRODUCTION: ['ru.yandex.rasp']},
    default=[
        'ru.yandex.rasp.sndbx',  # android sup-priemka
        'ru.yandex.mobile.trains.adhoc',  # ios sup-priemka
    ]
)

default_app_config = 'common.apps.info_center.app.InfoCenterAppConfig'
