# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from travel.rasp.library.python.common23.date import environment

from .models import Info, YadmNewsItem


log = logging.getLogger(__name__)


class YadmNewsItemSaver(object):
    class Error(Exception):
        pass

    def __init__(self, info_id):
        self.info_id = info_id
        self.info = None
        self.yadm_news_item = None

    def save(self, title, text, importance):
        try:
            self.info = Info.objects.get(id=self.info_id)
            self.yadm_news_item = YadmNewsItem(
                title=title,
                text=text,
                importance=importance,
                dt_created=environment.now()
            )
            self.info.yadm_news.append(self.yadm_news_item)
            self.info.save()

        except Exception as ex:
            msg = "Can't save yadm news item for info {}: {}".format(self.info_id, repr(ex))
            log.exception(msg)
            raise YadmNewsItemSaver.Error(msg)
