# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os.path

from django.conf import settings

from common.dynamic_settings.core import DynamicSetting
from common.dynamic_settings.default import conf
from common.settings.utils import define_setting


define_setting(
    'SUBURBAN_EVENTS_FORECAST_LOG',
    default=os.path.join(settings.LOG_PATH, 'yt/suburban_events_forecast.log')
)

define_setting(
    'RAW_RZD_EVENTS_LOG',
    default=os.path.join(settings.LOG_PATH, 'yt/raw_rzd_events_log.log')
)


conf.register_settings(
    SUBURBAN_EVENTS_ENABLED=DynamicSetting(True, cache_time=3 * 60,
                                           description='Отображать ли в сервисах информацию о прохождении электричек'),
    SUBURBAN_EXPORT_EVENTS_ENABLED=DynamicSetting(
        False, cache_time=1 * 60,
        description='Отображать ли в экспорте информацию о прохождении электричек'
    ),
    SUBURBAN_TRAIN_TURNOVER_ENABLED=DynamicSetting(False, cache_time=3 * 60,
                                                   description='Использовать ли оборот поездов'),
    SUBURBAN_ENABLE_NO_NEXT_DATA=DynamicSetting(True, cache_time=10 * 60,
                                                description='Включить прогноз застрявших в пути электричек'),
    SUBURBAN_ENABLE_NO_DATA=DynamicSetting(True, cache_time=10 * 60,
                                           description='Включить прогноз не отправившихся с первой станции электричек'),
    SUBURBAN_ENABLE_MCZK=DynamicSetting(False, cache_time=10 * 60,
                                        description='Включить отображение фактических данных для МЦК'),
    SUBURBAN_ENABLE_POSSIBLE_OK=DynamicSetting(True, cache_time=10 * 60,
                                               description='Включить прогноз "ожидается по расписанию"'),
    SUBURBAN_ENABLE_FACT_INTERPOLATION=DynamicSetting(True, cache_time=10 * 60,
                                                      description='Включить интерполяцию между известными фактами'),
    SUBURBAN_ENABLE_CANCELS=DynamicSetting(False, cache_time=10 * 60, description='Включить прогноз отмен'),
    SUBURBAN_MAX_EVENTS_TO_MATCH=DynamicSetting(
        3000, cache_time=5,
        description='Сколько событий РЖД матчим за раз'),

    # forecast settings
    SUBURBAN_NO_NEXT_DATA_ONLY_ARRIVAL=DynamicSetting(  # https://st.yandex-team.ru/SUBURBAN-323
        True, cache_time=1 * 60,
        description='Строить ли прогноз застревания только по событию прибытия'
    ),
    SUBURBAN_MIN_DELAY_TO_FORECAST=DynamicSetting(6, cache_time=10 * 60,
                                                  description='Опоздание для прогноза по фактическим данным'),
    SUBURBAN_MIN_DELAY_FOR_NO_NEXT_DATA_EVENT=DynamicSetting(6, cache_time=10 * 60,
                                                             description='Опоздание для застрявших в пути'),
    SUBURBAN_MIN_DELAY_FOR_NO_DATA_EVENT=DynamicSetting(12, cache_time=10 * 60,
                                                        description='Опоздание для не отправившихся с первой станции'),
    SUBURBAN_EVENT_PROPAGATION_DELTA=DynamicSetting(0, cache_time=10 * 60,
                                                    description='Значение опоздания до которого распространяется флаг'),
    SUBURBAN_MIN_DELAY_FOR_FACT_DT=DynamicSetting(2, cache_time=10 * 60,
                                                  description='Если фактическое опоздание меньше этого числа, '
                                                              'то считаем, что опоздания нет.'),
    SUBURBAN_MIN_EXTRA_TIME_FOR_FACT_DT=DynamicSetting(6, cache_time=10 * 60,
                                                       description='Опережение для отображения фактических'
                                                                   ' данных вместо нормативных'),
    SUBURBAN_DAYS_FOR_ACTUAL_STATIONS=DynamicSetting(1, cache_time=10 * 60,
                                                     description='Сколько дней считать станции актуальными'),
    SUBURBAN_REDUCTION_TIME_BY_HOUR=DynamicSetting(0, cache_time=10 * 60,
                                                   description='Параметр нагона (количество минут за один час)'),
    SUBURBAN_MIN_DELAY_FOR_TURNOVER=DynamicSetting(10, cache_time=10 * 60,
                                                   description='Прибавка к времени прибытия на конечную для оборота'),
    SUBURBAN_COMPANY_CRASH_RATE=DynamicSetting(
        0.4,
        cache_time=10 * 60,
        description='Процент от среднего количества событий по перевозчику для определения аварии'
    ),
    SUBURBAN_ALL_COMPANIES_CRASH_TIME=DynamicSetting(
        60,
        cache_time=10 * 60,
        description='Сколько минут нужно не получать события, чтобы считать, что аварии произошли по всем перевозчикам'
    ),
    SUBURBAN_WEEKS_DEEP=DynamicSetting(
        4,
        cache_time=10 * 60,
        description='Сколько недель в прошлом учитывать при рассчете среднего количества событий по перевозчикам'
    ),
    SUBURBAN_MAX_EVENT_DELAY=DynamicSetting(
        1000,
        cache_time=10 * 60,
        description='Опоздания больше данного количества минут игнорируются'
    ),
    SUBURBAN_MAX_EVENT_OVERTAKING=DynamicSetting(
        60,
        cache_time=10 * 60,
        description='Опережения больше данного количества минут игнорируются'
    ),

    # RZD data fetch settings
    SUBURBAN_RZD_FETCH_ENABLED=DynamicSetting(
        False, cache_time=20,
        description='Включено ли получение данных от РЖД'),
    SUBURBAN_RZD_MIN_FETCH_INTERVAL=DynamicSetting(
        60 * 5 + 10, cache_time=20,
        description='Минимальный интервал между запросами к РЖД'),
    SUBURBAN_RZD_SHIFT_FROM_NOW_TO_FETCH=DynamicSetting(
        0, cache_time=20,
        description='Смещение в прошлое, позже которого не пытаемся получать данные'),
    SUBURBAN_RZD_MAX_FETCH_TO_PAST=DynamicSetting(
        60 * 60, cache_time=20,
        description='Максимальная глубина запроса в прошлое (если долго не было данных, '
                    'пытаемся получить данные на такую глубину'),
    SUBURBAN_RZD_FETCH_RANGE_OVERLAP=DynamicSetting(
        2 * 60, cache_time=20,
        description='Перекрытие с предыдущим запросом, чтобы точно достать все данные'),

    # Movista settings
    SUBURBAN_MOVISTA_CANCELS_FETCH_DAYS=DynamicSetting(
        2, cache_time=20,
        description='На сколько дней (включая сегодня) запрашивать отмены у Мовисты'),
)

default_app_config = 'common.apps.suburban_events.app.SuburbanEventsAppConfig'
