from django.conf import settings

from common.db.mongo import databases


def setup():
    databases[settings.SUBURBAN_EVENTS_DATABASE_NAME].suburban_events_process.create_index('key', background=True)


def get_param(key):
    doc = databases[settings.SUBURBAN_EVENTS_DATABASE_NAME].suburban_events_process.find_one({'key': key})
    return doc['value'] if doc else None


def set_param(key, value):
    return databases[settings.SUBURBAN_EVENTS_DATABASE_NAME].suburban_events_process.update(
        {'key': key},
        {'$set': {'value': value}},
        upsert=True
    )
