# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
from datetime import datetime, timedelta
from functools import partial

from common.apps.suburban_events.models import (
    LVGD01_TR2PROC_query, LVGD01_TR2PROC, LVGD01_TR2PROC_feed, MovistaCancelRaw,
    ThreadEvents, ThreadState, ThreadStationState
)
from travel.rasp.library.python.common23.logging import log_run_time

log = logging.getLogger(__name__)
log_run_time = partial(log_run_time, logger=log)


OLD_DATA_DAYS = 15
OLD_FORECAST_DAYS = 3
OLD_FEED_DATA_DAYS = 30
OLD_MOVISTA_RAW_CANCELS_DAYS = 3


def clean():
    """ Удаляем старые данные."""

    old_date = (datetime.now() - timedelta(days=OLD_DATA_DAYS - 1)).date()
    old_forecast_date = (datetime.now() - timedelta(days=OLD_FORECAST_DAYS - 1)).date()
    old_feed_date = (datetime.now() - timedelta(days=OLD_FEED_DATA_DAYS - 1)).date()
    old_movista_raw_cancels_date = (datetime.now() - timedelta(days=OLD_MOVISTA_RAW_CANCELS_DAYS - 1)).date()

    with log_run_time('clean all data older than {}'.format(old_date)):
        with log_run_time('clean rzd queries'):
            log.info('LVGD01_TR2PROC objects removed: {}'.format(
                LVGD01_TR2PROC.objects.filter(TIMEOPER_F__lte=old_date).delete()
            ))

            log.info('LVGD01_TR2PROC_query objects removed: {}'.format(
                LVGD01_TR2PROC_query.objects.filter(queried_at__lte=old_feed_date).delete()
            ))

        with log_run_time('clean rzd events feed'):
            log.info('LVGD01_TR2PROC_feed objects removed: {}'.format(
                LVGD01_TR2PROC_feed.objects.filter(TIMEOPER_F__lte=old_feed_date).delete()
            ))

        with log_run_time('clean threads events'):
            log.info('ThreadEvents objects removed: {}'.format(
                ThreadEvents.objects.filter(key__thread_start_date__lte=old_date).delete()
            ))

        with log_run_time('clean forecasted threads states'):
            log.info('ThreadState objects removed: {}'.format(
                ThreadState.objects.filter(key__thread_start_date__lte=old_forecast_date).delete()
            ))

        with log_run_time('clean forecasted stations states'):
            log.info('ThreadStationState objects removed: {}'.format(
                ThreadStationState.objects.filter(key__thread_start_date__lte=old_forecast_date).delete()
            ))

        with log_run_time('clean movista raw cancels'):
            log.info("MovistaCancelRaw objects removed: {}".format(
                MovistaCancelRaw.objects.filter(departure_date__lte=old_movista_raw_cancels_date).delete()
            ))
