# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0018_remove_old_fileds_and_tables'),
    ]

    operations = [
        migrations.CreateModel(
            name='PlacePriceRules',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('rule_name', models.CharField(default='', max_length=1024, verbose_name='Название правила', blank=True)),
                ('coach_type', models.CharField(default='platzkarte', max_length=20, verbose_name='Тип вагона', blank=True, choices=[('suite', 'СВ'), ('compartment', 'купе'), ('platzkarte', 'плацкарт'), ('sitting', 'сидячие'), ('common', 'общий'), ('soft', 'мягкий')])),
                ('place_name', models.CharField(default='', help_text='например, верхние боковушки', max_length=1024, verbose_name='Название мест', blank=True)),
                ('place_numbers', models.CharField(default='', max_length=1024, null=True, verbose_name='Номера мест', blank=True)),
                ('priority', models.IntegerField(default=0, help_text='Приоритет правила (чем больше тем важнее)', verbose_name='Приоритет')),
                ('price_percent', models.FloatField(default=100, help_text='Процент полной цены билета', verbose_name='Процент')),
                ('train_number', models.CharField(default='', help_text='Регулярное выражение', max_length=1024, verbose_name='Номер поезда', blank=True)),
                ('service_class', models.CharField(default='', help_text='класс обслуживания ЖД - 2Э, ...', max_length=1024, verbose_name='Класс обслуживания ЖД', blank=True)),
                ('company', models.CharField(default='', max_length=1024, verbose_name='Перевозчик', blank=True)),
                ('departure_period_begin', models.DateField(null=True, verbose_name='Период отправления поезда (начало)', blank=True)),
                ('departure_period_end', models.DateField(null=True, verbose_name='Период отправления поезда (конец)', blank=True)),
                ('sale_period_begin', models.IntegerField(null=True, verbose_name='Начало продаж по акции (дней до отправления)', blank=True)),
                ('sale_period_end', models.IntegerField(null=True, verbose_name='Конец продаж по акции (дней до отправления', blank=True)),
                ('is_deluxe', models.NullBooleanField(verbose_name='Фирменный поезд')),
                ('coach_number', models.IntegerField(null=True, verbose_name='Номер вагона', blank=True)),
                ('is_dinamic_tariff', models.NullBooleanField(verbose_name='Динамический тариф')),
                ('station_from', models.ForeignKey(related_name='station_from_set', verbose_name='с какой станции', blank=True, to='www.Station', null=True)),
                ('station_to', models.ForeignKey(related_name='station_to_set', verbose_name='до какой станции', blank=True, to='www.Station', null=True)),
            ],
            options={
                'verbose_name': 'правило расчета тарифов на места в вагоне',
                'verbose_name_plural': 'правила расчета тарифов на места в вагоне',
            },
        ),
    ]
