# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import common.utils.fields
import django.core.validators


class Migration(migrations.Migration):

    dependencies = [
        ('train', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='CoachFacility',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(default='', max_length=1024, verbose_name='Название для админки', blank=True)),
                ('code', common.utils.fields.CodeCharField(unique=True, max_length=100, verbose_name='Код', validators=[django.core.validators.RegexValidator('[A-Za-z][_A-Za-z0-9]*', 'Код должен содержать только латинские буквы и цифры и знак "_"')])),
                ('icon', models.FileField(upload_to='data/train2/coach-facility', verbose_name='иконка в svg')),
                ('order', models.IntegerField(default=0, verbose_name='Порядок отображения')),
                ('title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, verbose_name='Название для отображения (ru)')),
                ('title_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='Название для отображения (en)', blank=True)),
                ('title_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='Название для отображения (tr)', blank=True)),
                ('title_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='Название для отображения (uk)', blank=True)),
            ],
            options={
                'verbose_name': 'Удобство в вагоне',
                'verbose_name_plural': 'Удобства в вагоне',
            },
        ),
        migrations.CreateModel(
            name='ServiceClass',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(default='', max_length=1024, verbose_name='Название для админки', blank=True)),
                ('code', common.utils.fields.CodeCharField(unique=True, max_length=100, verbose_name='Код, например "2Э"')),
                ('title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, verbose_name='Название для отображения (ru)')),
                ('title_en', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='Название для отображения (en)', blank=True)),
                ('title_tr', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='Название для отображения (tr)', blank=True)),
                ('title_uk', common.utils.fields.TrimmedCharField(default=None, max_length=100, null=True, verbose_name='Название для отображения (uk)', blank=True)),
            ],
            options={
                'verbose_name': 'Класс обслуживания',
                'verbose_name_plural': 'Классы обслуживания',
            },
        ),
    ]
