# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import common.utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('train', '0003_change_coachfacility_icon_upload_to'),
    ]

    operations = [
        migrations.AddField(
            model_name='serviceclass',
            name='brand_title',
            field=models.CharField(default='', max_length=100, verbose_name='Название бренда, например, САПСАН, ЛАСТОЧКА, SWIFT,..', blank=True),
        ),
        migrations.AddField(
            model_name='serviceclass',
            name='coach_category',
            field=models.CharField(default='', max_length=20, verbose_name='Категория вагона', blank=True, choices=[('КУПЕ', 'Купе'), ('ЛЮКС', 'Люкс'), ('МЯГК', 'Мягкий'), ('ОБЩ', 'Общий'), ('ПЛАЦ', 'Плацкарт'), ('СИД', 'Сидячий')]),
        ),
        migrations.AddField(
            model_name='serviceclass',
            name='coach_owner',
            field=models.CharField(default='', max_length=100, verbose_name='Владелец вагона, например, ФПК, РЖД, ДОСС,..', blank=True),
        ),
        migrations.AddField(
            model_name='serviceclass',
            name='description_en',
            field=models.TextField(default='', verbose_name='Описание класса обслуживания для отображения (en)', blank=True),
        ),
        migrations.AddField(
            model_name='serviceclass',
            name='description_ru',
            field=models.TextField(default='', verbose_name='Описание класса обслуживания для отображения (ru)'),
        ),
        migrations.AddField(
            model_name='serviceclass',
            name='description_tr',
            field=models.TextField(default='', verbose_name='Описание класса обслуживания для отображения (tr)', blank=True),
        ),
        migrations.AddField(
            model_name='serviceclass',
            name='description_uk',
            field=models.TextField(default='', verbose_name='Описание класса обслуживания для отображения (uk)', blank=True),
        ),
        migrations.AddField(
            model_name='serviceclass',
            name='end_date',
            field=models.DateField(default=None, null=True, verbose_name='Дата окончания действия класса обслуживания (может быть пустой)', blank=True),
        ),
        migrations.AddField(
            model_name='serviceclass',
            name='facilities',
            field=models.ManyToManyField(to='train.CoachFacility', verbose_name='Услуги', blank=True),
        ),
        migrations.AddField(
            model_name='serviceclass',
            name='is_firm_coach',
            field=models.CharField(default='any', max_length=20, verbose_name='Вагон является фирменным', choices=[('any', 'не важно'), ('yes', 'да'), ('no', 'нет')]),
        ),
        migrations.AddField(
            model_name='serviceclass',
            name='start_date',
            field=models.DateField(default=None, null=True, verbose_name='Дата начала действия класса обслуживания (может быть пустой)', blank=True),
        ),
        migrations.AddField(
            model_name='serviceclass',
            name='train_number',
            field=models.CharField(default='', help_text='Регулярное выражение', max_length=1024, verbose_name='Номер поезда', blank=True),
        ),
        migrations.AddField(
            model_name='serviceclass',
            name='two_storey',
            field=models.CharField(default='any', max_length=20, verbose_name='Двухэтажный вагон', choices=[('any', 'не важно'), ('yes', 'да'), ('no', 'нет')]),
        ),
        migrations.AlterField(
            model_name='serviceclass',
            name='code',
            field=common.utils.fields.CodeCharField(max_length=100, verbose_name='Код класса обслуживания, например "2Э"'),
        ),
        migrations.AlterField(
            model_name='serviceclass',
            name='title_en',
            field=common.utils.fields.TrimmedCharField(default='', max_length=100, verbose_name='Название для отображения (короткое) (en)', blank=True),
        ),
        migrations.AlterField(
            model_name='serviceclass',
            name='title_ru',
            field=common.utils.fields.TrimmedCharField(default='', max_length=100, verbose_name='Название для отображения (короткое) (ru)'),
        ),
        migrations.AlterField(
            model_name='serviceclass',
            name='title_tr',
            field=common.utils.fields.TrimmedCharField(default='', max_length=100, verbose_name='Название для отображения (короткое) (tr)', blank=True),
        ),
        migrations.AlterField(
            model_name='serviceclass',
            name='title_uk',
            field=common.utils.fields.TrimmedCharField(default='', max_length=100, verbose_name='Название для отображения (короткое) (uk)', blank=True),
        ),
    ]
