# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import common.utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('train', '0004_update_service_class'),
    ]

    operations = [
        migrations.CreateModel(
            name='UFSErrorDescription',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(default='', max_length=1024, verbose_name='Название для админки', blank=True)),
                ('ufs_code', common.utils.fields.CodeCharField(unique=True, max_length=20, verbose_name='Код ошибки УФС')),
                ('ufs_description', models.TextField(default='', verbose_name='Оригинальное описание ошибки от УФС', blank=True)),
                ('show', models.BooleanField(default=False, verbose_name='Показывать вместо стандартного сообщения об ошибке')),
                ('description_ru', models.TextField(default='', verbose_name='Описание ошибки для отображения (ru)', blank=True)),
                ('description_en', models.TextField(default='', verbose_name='Описание ошибки для отображения (en)', blank=True)),
                ('description_tr', models.TextField(default='', verbose_name='Описание ошибки для отображения (tr)', blank=True)),
                ('description_uk', models.TextField(default='', verbose_name='Описание ошибки для отображения (uk)', blank=True)),
            ],
            options={
                'verbose_name': 'Описание ошибки УФС',
                'verbose_name_plural': 'Описания ошибок УФС',
            },
        ),
        migrations.AlterField(
            model_name='serviceclass',
            name='is_firm_coach',
            field=models.NullBooleanField(default=None, verbose_name='Вагон является фирменным'),
        ),
        migrations.AlterField(
            model_name='serviceclass',
            name='two_storey',
            field=models.NullBooleanField(default=None, verbose_name='Двухэтажный вагон'),
        ),
    ]
