# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import common.utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('train', '0009_ufsneworderblacklist'),
    ]

    operations = [
        migrations.AlterField(
            model_name='serviceclass',
            name='coach_owner',
            field=models.CharField(default='', max_length=100, verbose_name='Владельцы вагонов (через запятую), например, ФПК, РЖД, ДОСС', blank=True),
        ),
        migrations.AlterField(
            model_name='serviceclass',
            name='description_ru',
            field=models.TextField(default='', verbose_name='Описание класса обслуживания для отображения (ru)', blank=True),
        ),
        migrations.AlterField(
            model_name='ufsneworderblacklist',
            name='comment',
            field=models.TextField(null=True, verbose_name='Комментарий', blank=True),
        ),
        migrations.AlterField(
            model_name='ufsneworderblacklist',
            name='number',
            field=common.utils.fields.TrimmedCharField(help_text='Список номеров через запятую', max_length=500, verbose_name='Номера'),
        ),
    ]
