# -*- coding: utf-8 -*-
# Generated by Django 1.9.12 on 2017-08-01 17:56
from __future__ import unicode_literals

import common.utils.fields
import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('train', '0010_optional_description_and_other_fixes'),
    ]

    operations = [
        migrations.CreateModel(
            name='TariffInfo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', common.utils.fields.CodeCharField(max_length=100, unique=True, validators=[django.core.validators.RegexValidator('[A-Za-z][_A-Za-z0-9]*', 'Код должен содержать только латинские буквы и цифры и знак "_"')], verbose_name='Код')),
                ('need_document', models.BooleanField(default=False, verbose_name='Необходим документ')),
                ('without_place', models.BooleanField(default=False, verbose_name='Тариф без места')),
                ('min_age', models.PositiveIntegerField(default=0, verbose_name='Нижняя граница возраста пассажира')),
                ('min_age_includes_birthday', models.BooleanField(default=False, verbose_name='Нижняя граница включает день рождения')),
                ('max_age', models.PositiveIntegerField(default=150, verbose_name='Верхняя граница возраста пассажира')),
                ('max_age_includes_birthday', models.BooleanField(default=False, verbose_name='Верхняя граница включает день рождения')),
                ('ufs_request_code', common.utils.fields.TrimmedCharField(max_length=500, verbose_name='Код тарифа для запроса в УФС')),
                ('ufs_response_codes', common.utils.fields.TrimmedCharField(help_text='Список через запятую', max_length=500, verbose_name='Коды тарифа из ответа от УФС')),
                ('im_request_code', common.utils.fields.TrimmedCharField(max_length=500, verbose_name='Код тарифа для запроса в ИМ')),
                ('im_response_codes', common.utils.fields.TrimmedCharField(help_text='Список через запятую', max_length=500, verbose_name='Коды тарифа из ответа от ИМ')),
                ('title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, verbose_name='Название для отображения (ru)')),
                ('title_en', common.utils.fields.TrimmedCharField(blank=True, default=None, max_length=100, null=True, verbose_name='Название для отображения (en)')),
                ('title_tr', common.utils.fields.TrimmedCharField(blank=True, default=None, max_length=100, null=True, verbose_name='Название для отображения (tr)')),
                ('title_uk', common.utils.fields.TrimmedCharField(blank=True, default=None, max_length=100, null=True, verbose_name='Название для отображения (uk)')),
            ],
            options={
                'verbose_name': 'Информация о тарифе',
                'verbose_name_plural': 'Информация о тарифах',
            },
        ),
    ]
